set echo off
Rem
Rem $Header: rdbms/demo/syncref_setup.sql /main/1 2012/01/26 19:01:42 sramakri Exp $
Rem
Rem syncref_setup.sql
Rem
Rem Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      syncref_setup.sql - Sync Refresh demo setup
Rem
Rem    DESCRIPTION
Rem      Creates the user SYNCREF_USER and tablespaces
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sramakri    01/15/12 - update
Rem    sramakri    01/09/12 - Sync Refresh demo
Rem    sramakri    01/09/12 - Created
Rem

SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

connect sys/knl_test7 as sysdba;


-- Default Tablespace for syncref_user
create tablespace syncref_user_tbs
  datafile 'syncref_user_tbs.f' size 2m reuse autoextend on
  default storage (initial 64k next 64k pctincrease 0 maxextents unlimited);

--
-- Tablespaces for the fact table partitions
--

-- partition 1
create tablespace syncref_fp1_tbs
  datafile 'syncref_fact2_tbs.f' size 2m reuse autoextend on
  default storage (initial 64k next 64k pctincrease 0 maxextents unlimited);

-- partition 2
create tablespace syncref_fp2_tbs
  datafile 'syncref_fp2_tbs.f' size 2m reuse autoextend on
  default storage (initial 64k next 64k pctincrease 0 maxextents unlimited);

-- partition 3
create tablespace syncref_fp3_tbs
  datafile 'syncref_fp3_tbs.f' size 2m reuse autoextend on
  default storage (initial 64k next 64k pctincrease 0 maxextents unlimited);

--
-- Tablespaces for the MV partitions
--

-- partition 1
create tablespace syncref_mvp1_tbs
  datafile 'syncref_mvp1_tbs.f' size 2m reuse autoextend on
  default storage (initial 64k next 64k pctincrease 0 maxextents unlimited);

-- partition 2
create tablespace syncref_mvp2_tbs
  datafile 'syncref_mvp2_tbs.f' size 2m reuse autoextend on
  default storage (initial 64k next 64k pctincrease 0 maxextents unlimited);

-- partition 3
create tablespace syncref_mvp3_tbs
  datafile 'syncref_mvp3_tbs.f' size 2m reuse autoextend on
  default storage (initial 64k next 64k pctincrease 0 maxextents unlimited);


-- create syncref_user 
create user syncref_user identified by syncref_user 
  default tablespace syncref_user_tbs
  temporary tablespace temp
  profile default account unlock; 
grant unlimited tablespace to syncref_user ;
grant dba to syncref_user;

disconnect;

set echo on
